<?php
/** @var array $app */
/** @var string $pageTitle */
/** @var string|null $metaDescription */
/** @var string $content */

$fullTitle = ($pageTitle ? htmlspecialchars($pageTitle) . ' • ' : '') . htmlspecialchars($app['name']);
$desc = htmlspecialchars($metaDescription ?? 'InfoZone Forum: modern discussion and community.');
$canonical = rtrim($app['url'], '/') . ($_SERVER['REQUEST_URI'] ?? '/');
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= $fullTitle ?></title>
  <meta name="description" content="<?= $desc ?>">
  <link rel="canonical" href="<?= htmlspecialchars($canonical) ?>">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="/assets/app.css" rel="stylesheet">
</head>
<body class="bg-body-tertiary">
<header class="sticky-top border-bottom bg-white">
  <nav class="navbar navbar-expand-lg container py-2">
    <a class="navbar-brand fw-bold" href="/">InfoZone</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMain">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navMain">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="/">Forums</a></li>
        <li class="nav-item"><a class="nav-link" href="/acp">ACP</a></li>
      </ul>
      <form class="d-flex" action="/search" method="get">
        <input class="form-control form-control-sm me-2" type="search" name="q" placeholder="Search">
        <button class="btn btn-sm btn-outline-primary" type="submit">Search</button>
      </form>
    </div>
  </nav>
</header>

<main class="container my-4">
  <div class="row g-4">
    <aside class="col-12 col-lg-3 order-2 order-lg-1">
      <div class="card rounded-4 shadow-sm">
        <div class="card-body">
          <h2 class="h6 fw-bold mb-3">Sidebar</h2>
          <ul class="list-unstyled small mb-0">
            <li><a href="/" class="link-dark text-decoration-none">Latest topics (stub)</a></li>
            <li><a href="/" class="link-dark text-decoration-none">Trending tags (stub)</a></li>
            <li><a href="/" class="link-dark text-decoration-none">Leaderboard (stub)</a></li>
          </ul>
        </div>
      </div>

      <div class="card rounded-4 shadow-sm mt-4">
        <div class="card-body">
          <h2 class="h6 fw-bold mb-2">Sponsored</h2>
          <div class="ad-slot small text-muted border rounded-3 p-3 text-center">
            Ad placeholder (responsive)
          </div>
        </div>
      </div>
    </aside>

    <section class="col-12 col-lg-9 order-1 order-lg-2">
      <?= $content ?>
    </section>
  </div>
</main>

<footer class="border-top bg-white">
  <div class="container py-4 d-flex flex-column flex-md-row justify-content-between gap-2">
    <div class="small text-muted">© <?= date('Y') ?> <?= htmlspecialchars($app['name']) ?></div>
    <div class="small">
      <a class="text-decoration-none me-3" href="/terms">Terms</a>
      <a class="text-decoration-none" href="/privacy">Privacy</a>
    </div>
  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
