<?php
use InfoZone\Support\View;
use InfoZone\Support\Csrf;

ob_start();
?>
<div class="d-flex align-items-start justify-content-between mb-3">
  <div>
    <h1 class="h3 fw-bold mb-1">Forums</h1>
    <div class="text-muted">Create, update, delete, and reorder forums.</div>
  </div>
</div>

<div class="row g-4">
  <div class="col-12 col-lg-5">
    <div class="card rounded-4 shadow-sm">
      <div class="card-body">
        <h2 class="h6 fw-bold mb-3">Create forum</h2>
        <form method="post" action="/acp/forums/create">
          <?= Csrf::inputField(); ?>
          <div class="mb-2">
            <label class="form-label small text-muted">Category</label>
            <select class="form-select form-select-sm" name="category_id" required>
              <?php foreach ($categories as $c): ?>
                <option value="<?= (int)$c['id'] ?>"><?= htmlspecialchars($c['title']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-2">
            <label class="form-label small text-muted">Title</label>
            <input class="form-control form-control-sm" name="title" required maxlength="120">
          </div>
          <div class="mb-2">
            <label class="form-label small text-muted">Slug (optional)</label>
            <input class="form-control form-control-sm" name="slug" maxlength="160" placeholder="auto-generated if empty">
          </div>
          <div class="mb-2">
            <label class="form-label small text-muted">Description</label>
            <textarea class="form-control form-control-sm" name="description" rows="3"></textarea>
          </div>
          <div class="row g-2">
            <div class="col-6">
              <label class="form-label small text-muted">Sort order</label>
              <input class="form-control form-control-sm" name="sort_order" type="number" value="0">
            </div>
            <div class="col-6 d-flex align-items-end">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" name="is_locked" id="is_locked">
                <label class="form-check-label small" for="is_locked">Locked</label>
              </div>
            </div>
          </div>
          <button class="btn btn-primary btn-sm rounded-3 mt-3" type="submit">Create</button>
        </form>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-7">
    <div class="card rounded-4 shadow-sm">
      <div class="card-body">
        <h2 class="h6 fw-bold mb-3">Existing forums</h2>

        <form method="post" action="/acp/forums/reorder" class="mb-3">
          <?= Csrf::inputField(); ?>
          <div class="small text-muted mb-2">Edit order values and save.</div>
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead>
                <tr><th>ID</th><th>Title</th><th>Category</th><th style="width:110px;">Order</th></tr>
              </thead>
              <tbody>
                <?php foreach ($forums as $f): ?>
                <tr>
                  <td><?= (int)$f['id'] ?></td>
                  <td class="fw-semibold"><?= htmlspecialchars($f['title']) ?></td>
                  <td><?= (int)$f['category_id'] ?></td>
                  <td><input class="form-control form-control-sm" type="number" name="orders[<?= (int)$f['id'] ?>]" value="<?= (int)$f['sort_order'] ?>"></td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <button class="btn btn-outline-primary btn-sm rounded-3" type="submit">Save order</button>
        </form>

        <hr>

        <div class="accordion" id="forumEdit">
          <?php foreach ($forums as $f): ?>
          <div class="accordion-item">
            <h2 class="accordion-header" id="h<?= (int)$f['id'] ?>">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#c<?= (int)$f['id'] ?>">
                #<?= (int)$f['id'] ?> — <?= htmlspecialchars($f['title']) ?>
              </button>
            </h2>
            <div id="c<?= (int)$f['id'] ?>" class="accordion-collapse collapse" data-bs-parent="#forumEdit">
              <div class="accordion-body">
                <form method="post" action="/acp/forums/update" class="mb-2">
                  <?= Csrf::inputField(); ?>
                  <input type="hidden" name="id" value="<?= (int)$f['id'] ?>">
                  <div class="row g-2">
                    <div class="col-12 col-md-6">
                      <label class="form-label small text-muted">Category</label>
                      <select class="form-select form-select-sm" name="category_id" required>
                        <?php foreach ($categories as $c): ?>
                          <option value="<?= (int)$c['id'] ?>" <?= ((int)$c['id'] === (int)$f['category_id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($c['title']) ?>
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                    <div class="col-12 col-md-6">
                      <label class="form-label small text-muted">Title</label>
                      <input class="form-control form-control-sm" name="title" maxlength="120" value="<?= htmlspecialchars($f['title']) ?>" required>
                    </div>
                    <div class="col-12 col-md-6">
                      <label class="form-label small text-muted">Slug</label>
                      <input class="form-control form-control-sm" name="slug" maxlength="160" value="<?= htmlspecialchars($f['slug']) ?>">
                    </div>
                    <div class="col-12 col-md-6">
                      <label class="form-label small text-muted">Sort order</label>
                      <input class="form-control form-control-sm" name="sort_order" type="number" value="<?= (int)$f['sort_order'] ?>">
                    </div>
                    <div class="col-12">
                      <label class="form-label small text-muted">Description</label>
                      <textarea class="form-control form-control-sm" name="description" rows="2"><?= htmlspecialchars($f['description'] ?: '') ?></textarea>
                    </div>
                    <div class="col-12">
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="is_locked" id="l<?= (int)$f['id'] ?>" <?= ((int)$f['is_locked'] === 1) ? 'checked' : '' ?>>
                        <label class="form-check-label small" for="l<?= (int)$f['id'] ?>">Locked</label>
                      </div>
                    </div>
                  </div>
                  <button class="btn btn-primary btn-sm rounded-3 mt-3" type="submit">Save changes</button>
                </form>

                <form method="post" action="/acp/forums/delete" onsubmit="return confirm('Delete this forum?');">
                  <?= Csrf::inputField(); ?>
                  <input type="hidden" name="id" value="<?= (int)$f['id'] ?>">
                  <button class="btn btn-outline-danger btn-sm rounded-3" type="submit">Delete forum</button>
                </form>
              </div>
            </div>
          </div>
          <?php endforeach; ?>
          <?php if (!$forums): ?><div class="text-muted small">No forums created yet.</div><?php endif; ?>
        </div>

      </div>
    </div>
  </div>
</div>

<?php
$content = ob_get_clean();
echo View::render('layouts/acp.php', compact('content','pageTitle'));
