<?php
declare(strict_types=1);

namespace InfoZone\Support;

final class View
{
    private static string $base;
    private static array $app;

    public static function init(string $baseTemplatesPath, array $appConfig): void
    {
        self::$base = rtrim($baseTemplatesPath, '/');
        self::$app = $appConfig;
    }

    public static function render(string $template, array $data = []): string
    {
        $file = self::$base . '/' . ltrim($template, '/');
        if (!is_file($file)) throw new \RuntimeException("Template not found: {$template}");

        $app = self::$app;
        extract($data, EXTR_SKIP);

        ob_start();
        require $file;
        return (string)ob_get_clean();
    }
}
