<?php
declare(strict_types=1);

namespace InfoZone\Support;

final class Csrf
{
    private static string $key = '_csrf';

    public static function init(string $key): void
    {
        self::$key = $key;
        if (!isset($_SESSION[self::$key])) $_SESSION[self::$key] = bin2hex(random_bytes(32));
    }

    public static function token(): string
    {
        return (string)($_SESSION[self::$key] ?? '');
    }

    public static function inputField(): string
    {
        $t = htmlspecialchars(self::token(), ENT_QUOTES, 'UTF-8');
        return '<input type="hidden" name="' . self::$key . '" value="' . $t . '">';
    }

    public static function verify(array $post): void
    {
        $sent = (string)($post[self::$key] ?? '');
        if (!$sent || !hash_equals(self::token(), $sent)) {
            http_response_code(419);
            echo 'CSRF token mismatch.';
            exit;
        }
    }
}
