<?php
declare(strict_types=1);

namespace InfoZone\Repository;

final class PermissionRepository extends BaseRepository
{
    public function userHasPermission(int $userId, string $permKey): bool
    {
        $st = $this->db->prepare("
            SELECT 1
            FROM user_roles ur
            JOIN role_permissions rp ON rp.role_id = ur.role_id
            JOIN permissions p ON p.id = rp.permission_id
            WHERE ur.user_id = :uid AND p.perm_key = :k
            LIMIT 1
        ");
        $st->execute([':uid' => $userId, ':k' => $permKey]);
        return (bool)$st->fetchColumn();
    }
}
