<?php
declare(strict_types=1);

namespace InfoZone\Controller;

use InfoZone\Http\Request;
use InfoZone\Http\Response;
use InfoZone\Repository\ForumRepository;
use InfoZone\Support\View;

final class ForumController
{
    public function index(Request $req, array $params): Response
    {
        $categories = (new ForumRepository())->listCategoriesWithForums();

        $html = View::render('forum/index.php', [
            'categories' => $categories,
            'pageTitle' => 'Forum Index',
            'metaDescription' => 'InfoZone Forum: categories, forums, and the latest discussions.',
        ]);

        return Response::html($html);
    }

    public function viewForum(Request $req, array $params): Response
    {
        $id = (int)($params['id'] ?? 0);
        $repo = new ForumRepository();
        $forum = $repo->findForum($id);

        if (!$forum) return Response::html(View::render('errors/404.php', ['pageTitle' => 'Not Found']), 404);

        $topics = $repo->listTopics($id);

        $html = View::render('forum/view.php', [
            'forum' => $forum,
            'topics' => $topics,
            'pageTitle' => $forum['title'],
            'metaDescription' => $forum['description'] ?: ('Topics in ' . $forum['title']),
        ]);

        return Response::html($html);
    }
}
