<?php
declare(strict_types=1);

namespace InfoZone\Controller\Acp;

use InfoZone\Http\Request;
use InfoZone\Http\Response;
use InfoZone\Support\View;
use InfoZone\Security\Ability;
use InfoZone\Core\Database;

final class DashboardController
{
    public function index(Request $req, array $params): Response
    {
        Ability::require('acp.access');

        $db = Database::pdo();
        $stats = [
            'users' => (int)$db->query("SELECT COUNT(*) FROM users")->fetchColumn(),
            'topics' => (int)$db->query("SELECT COUNT(*) FROM topics")->fetchColumn(),
            'posts' => (int)$db->query("SELECT COUNT(*) FROM posts")->fetchColumn(),
            'reports_open' => (int)$db->query("SELECT COUNT(*) FROM moderation_reports WHERE status='open'")->fetchColumn(),
        ];

        $html = View::render('acp/dashboard.php', [
            'stats' => $stats,
            'pageTitle' => 'ACP Dashboard',
        ]);

        return Response::html($html);
    }
}
