# InfoZone Forum (starter)

Working starter scaffold for **InfoZone Forum**: PHP 8.1+ / MySQL, shared-hosting friendly, with a modern forum UI, an ACP (admin control panel), RBAC permissions, and CSRF.

## Requirements
- PHP 8.1+
- MySQL 5.7+ / MariaDB 10.3+
- Composer

## Install
1. Copy `.env.example` to `.env` and edit DB credentials + `APP_URL`.
2. Install deps:
   ```bash
   composer install
   composer dump-autoload
   ```
3. Create DB and import schema:
   ```bash
   mysql -u USER -p DBNAME < database/schema.sql
   ```
4. Point your domain document root to `public/` (recommended).

## URLs
- `/` forum index
- `/forum/{id}` forum topic list
- `/topic/{id}` topic thread view
- `/acp` ACP dashboard
- `/acp/forums` ACP forums management

## Seed credentials
- Username: `admin`
- Password: `admin123` (change immediately)
