<?php
namespace infozone\ads\acp;

class ads_module
{
    public $u_action;

    protected $db;
    protected $request;
    protected $template;
    protected $user;
    protected $config;
    protected $language;
    protected $root_path;
    protected $php_ext;

    public function __construct($db, $request, $template, $user, $config, $language, $root_path, $php_ext)
    {
        $this->db = $db;
        $this->request = $request;
        $this->template = $template;
        $this->user = $user;
        $this->config = $config;
        $this->language = $language;
        $this->root_path = $root_path;
        $this->php_ext = $php_ext;
    }

    public function main($id, $mode)
    {
        $this->language->add_lang('info_acp_ads', 'infozone/ads');
        $this->tpl_name = 'acp_ads_manage.html';
        $this->page_title = $this->user->lang('ACP_INFOZONE_ADS_MANAGE');

        add_form_key('infozone_ads');

        // Ensure default slots exist
        $this->ensure_default_slots();

        $submit = $this->request->is_set_post('submit');
        if ($submit)
        {
            if (!check_form_key('infozone_ads'))
            {
                trigger_error('FORM_INVALID');
            }

            // Save Paystack keys
            $this->config->set('infozone_ads_paystack_public', $this->request->variable('paystack_public', '', true));
            $this->config->set('infozone_ads_paystack_secret', $this->request->variable('paystack_secret', '', true));
            $this->config->set('infozone_ads_currency', $this->request->variable('currency', 'NGN', true));
            $this->config->set('infozone_ads_default_amount_kobo', $this->request->variable('default_amount_kobo', 500000));

            $slots = $this->request->variable('slot', ['' => ['type'=>'', 'image_path'=>'', 'link_url'=>'', 'html_code'=>'', 'enabled'=>0]], true);

            foreach ($slots as $slot_key => $data)
            {
                $slot_key = (string) $slot_key;
                $type = $data['type'] ?? 'empty';
                $image_path = $data['image_path'] ?? '';
                $link_url = $data['link_url'] ?? '';
                $html_code = $data['html_code'] ?? '';
                $enabled = !empty($data['enabled']) ? 1 : 0;

                $sql = 'UPDATE ' . $this->db->get_table_prefix() . "infozone_ad_slots
                        SET type = '" . $this->db->sql_escape($type) . "',
                            image_path = '" . $this->db->sql_escape($image_path) . "',
                            link_url = '" . $this->db->sql_escape($link_url) . "',
                            html_code = '" . $this->db->sql_escape($html_code) . "',
                            enabled = " . (int)$enabled . ",
                            updated_at = " . time() . "
                        WHERE slot_key = '" . $this->db->sql_escape($slot_key) . "'";
                $this->db->sql_query($sql);
            }

            trigger_error($this->user->lang('IZ_ADS_SAVED') . adm_back_link($this->u_action));
        }

        // Load slots
        $sql = 'SELECT * FROM ' . $this->db->get_table_prefix() . "infozone_ad_slots ORDER BY slot_key ASC";
        $result = $this->db->sql_query($sql);
        while ($row = $this->db->sql_fetchrow($result))
        {
            $this->template->assign_block_vars('slots', [
                'SLOT_KEY' => $row['slot_key'],
                'TYPE' => $row['type'],
                'IMAGE_PATH' => $row['image_path'],
                'LINK_URL' => $row['link_url'],
                'HTML_CODE' => $row['html_code'],
                'ENABLED' => (int)$row['enabled'],
            ]);
        }
        $this->db->sql_freeresult($result);

        $this->template->assign_vars([
            'U_ACTION' => $this->u_action,
            'PAYSTACK_PUBLIC' => $this->config['infozone_ads_paystack_public'],
            'PAYSTACK_SECRET' => $this->config['infozone_ads_paystack_secret'],
            'CURRENCY' => $this->config['infozone_ads_currency'] ?: 'NGN',
            'DEFAULT_AMOUNT_KOBO' => (int)$this->config['infozone_ads_default_amount_kobo'],
        ]);
    }

    protected function ensure_default_slots()
    {
        $keys = [
            'index_left_1','index_left_2','index_left_3',
            'index_right_1','index_right_2','index_right_3',
            'index_top_1','index_top_2','index_top_3',
            'index_after_forums_1','index_after_forums_2','index_after_forums_3',
            'index_before_footer_1','index_before_footer_2','index_before_footer_3',
        ];

        foreach ($keys as $k)
        {
            $sql = 'SELECT id FROM ' . $this->db->get_table_prefix() . "infozone_ad_slots WHERE slot_key = '" . $this->db->sql_escape($k) . "'";
            $result = $this->db->sql_query($sql);
            $row = $this->db->sql_fetchrow($result);
            $this->db->sql_freeresult($result);

            if (!$row)
            {
                $sql_ary = [
                    'slot_key' => $k,
                    'type' => 'empty',
                    'enabled' => 1,
                    'updated_at' => time(),
                ];
                $sql = 'INSERT INTO ' . $this->db->get_table_prefix() . 'infozone_ad_slots ' . $this->db->sql_build_array('INSERT', $sql_ary);
                $this->db->sql_query($sql);
            }
        }
    }
}
