# InfoZone phpBB Style – Fix Notes (2026-01-31)

## Primary issues found
- **CSS conflicts / overrides**: `theme/stylesheet.css` contained multiple competing skins (Luxe Light + Board Index + “Blackmagic” skin) and a global `text-align:center` rule, causing inconsistent typography/layout and broken alignment across UCP/MCP/viewtopic/search.
- **Dropdown & submenu visibility**: menus relied on `[hidden]` toggling but lacked defensive CSS (`[hidden] {display:none}`) and stacking context (`z-index`), so menus could appear clipped/behind other layers on some pages/browsers.
- **Template robustness**: a few custom variables (e.g., `IN_BADGE`, `FLATBOOTS_MINI_CMS_ENABLED`, `IZ_ADS`) were referenced without `is defined` guards, which can break pages when strict Twig handling is enabled or when extensions are absent.

## Fixes applied
### CSS (`theme/stylesheet.css`)
- Removed the entire secondary “Blackmagic Forum inspired skin” block that overwrote `:root`, `body`, header and navigation styles.
- Removed the global `text-align:center` rule that centered *all* content.
- Added:
  - `z-index` and `[hidden]` handling for `.iz-nav__menu`
  - `.iz-nav__menu--account { right:0; left:auto; }` to prevent off-screen dropdowns
  - modal scroll-lock (`html.iz-modal-open`)
  - consistent base styles for phpBB form controls, buttons, and pagination
  - safer wrapping for long post content

### JS (`template/overall_footer.html`)
- Added lightweight polyfills for `Element.matches` and `Element.closest` to avoid dropdown/search failures in edge cases.

### Templates
- `template/overall_header.html`
  - Guarded `IN_BADGE` and `FLATBOOTS_MINI_CMS_ENABLED` with `is defined` checks.
- `template/index_body.html`
  - Guarded `IZ_ADS` usage with `IZ_ADS is defined`
  - Added a safe default for `IZ_ADVERTISE_URL`.

## Apply / deploy
1. Upload/replace the style files on your server (or install via ACP → Customise → Styles).
2. **Purge cache**: ACP → General → Purge the cache.
3. Hard refresh your browser (Ctrl/Cmd+Shift+R) to bypass cached CSS/JS.

## Maintenance tips
- Keep **one** active design system per stylesheet (avoid appending multiple “skins” into one file).
- When referencing extension-provided template vars, always use `is defined` guards.
- After editing templates, purge phpBB cache every time.
